import { world, system } from "@minecraft/server";
import { ActionFormData } from "@minecraft/server-ui";

world.afterEvents.playerInteractWithEntity.subscribe(event => {
    const { player, target } = event;
    if (!target || target.typeId !== "hivehub:npc_plus") return;

    handleTeleportation(player);
});


world.afterEvents.entityHitEntity.subscribe(event => {
    const { damagingEntity, hitEntity } = event;
    if (!(damagingEntity?.typeId === "minecraft:player")) return;
    if (!hitEntity || hitEntity.typeId !== "hivehub:npc_plus") return;

    handleTeleportation(damagingEntity);
});


function handleTeleportation(player) {
    try {
        if (
            player.hasTag("gwim:VIP") ||
            player.hasTag("gwim:Admin") ||
            player.hasTag("gwim:God") ||
            player.hasTag("gwim:VIPPlus") ||
            player.hasTag("gwim:Elite") ||
            player.hasTag("gwim:ElitePlus")
        ) {
            const over = world.getDimension("minecraft:overworld");
            over.runCommandAsync(`tp "${player.name}" 4000 5 4000 facing 4001 5 4000`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
        } else {
            player.sendMessage("§cYou need a VIP rank to enter here!");
            player.playSound("note.bass");
        }
    } catch (error) {
        console.error(error);
    }
}